<ul class="p-0 m-0">
    <?php if(is_countable($todos) && count($todos) > 0): ?>
    <?php $__currentLoopData = $todos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $todo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <li class="d-flex mb-4 pb-1">
        <div class="avatar flex-shrink-0">
            <input type="checkbox" id="<?php echo e($todo->id); ?>" onclick="update_status(this)" name="<?php echo e($todo->id); ?>" class="form-check-input mt-0" <?php echo e($todo->is_completed ? 'checked' : ''); ?>>
        </div>
        <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
            <div class="me-2">
                <div class="d-flex align-items-center justify-content-between">
                    <h6 class="mb-0 <?php echo e($todo->is_completed ? 'striked' : ''); ?>" id="<?php echo e($todo->id); ?>_title"><?php echo e($todo->title); ?></h6>
                    <div class="user-progress d-flex align-items-center gap-1">
                        <a href="javascript:void(0);" class="edit-todo" data-bs-toggle="modal" data-bs-target="#edit_todo_modal" data-id="<?php echo e($todo->id); ?>" title="<?php echo e(get_label('update', 'Update')); ?>">
                            <i class="bx bx-edit mx-1"></i>
                        </a>
                        <a href="javascript:void(0);" class="delete" data-id="<?php echo e($todo->id); ?>" data-type="todos" title="<?php echo e(get_label('delete', 'Delete')); ?>">
                            <i class="bx bx-trash text-danger mx-1"></i>
                        </a>
                    </div>
                </div>
                <small class="text-muted d-block my-1"><?php echo e(format_date($todo->created_at, true)); ?></small>
            </div>
        </div>
    </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
    <div class="h-100 d-flex justify-content-center align-items-center">
        <span><?php echo e(get_label('todos_not_found', 'Todos not found!')); ?></span>
    </div>
    <?php endif; ?>
</ul>
<?php /**PATH /home/capoit/apps.capo.it.com/resources/views/components/dashboard/todo-list.blade.php ENDPATH**/ ?>