
<title><?php echo e(get_label('login', 'Login')); ?> - <?php echo e($general_settings['company_title']); ?></title>
<?php $__env->startSection('content'); ?>
    <!-- Content -->
    <div class="container-fluid">
        <?php if(config('constants.ALLOW_MODIFICATION') === 0): ?>
            <div class="col-12 mt-4 text-center">
                <div class="alert alert-warning mb-0">
                    <b>Note:</b> If you cannot log in here, please close the codecanyon frame by clicking on <b>x Remove
                        Frame</b> button from the top right corner of the page or <a href="<?php echo e(url('/')); ?>"
                        target="_blank">&gt;&gt; Click here &lt;&lt;</a>
                </div>
            </div>
        <?php endif; ?>
        <div class="authentication-wrapper authentication-basic container-p-y">
            <div class="authentication-inner">
                <!-- Register -->
                <div class="card">
                    <div class="card-body">
                        <!-- Logo -->
                        <div class="app-brand justify-content-center">
                            <a href="<?php echo e(url('/')); ?>" class="app-brand-link gap-2">
                                <span class="app-brand-logo demo">
                                    <img src="<?php echo e(asset($general_settings['full_logo'])); ?>" width="300px" alt="" />
                                </span>
                            </a>
                        </div>
                        <!-- /Logo -->
                        <h4 class="mb-2"><?php echo e(get_label('welcome_to', 'Welcome to')); ?>

                            <?= $general_settings['company_title'] ?>! 👋</h4>
                        <p><?php echo e(get_label('sign_into_your_account', 'Sign into your account')); ?></p>
                        <form id="formAuthentication" class="form-submit-event mb-3"
                            action="<?php echo e(url('users/authenticate')); ?>" method="POST">
                            <input type="hidden" name="redirect_url" value="<?php echo e(url('home')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="email" class="form-label"><?php echo e(get_label('email', 'Email')); ?> <span
                                        class="asterisk">*</span></label>
                                <input type="text" class="form-control" id="email" name="email"
                                    placeholder="<?= get_label('please_enter_email', 'Please enter email') ?>"
                                    value="<?= config('constants.ALLOW_MODIFICATION') === 0 ? 'admin@gmail.com' : '' ?>"
                                    autofocus />
                            </div>
                            <div class="form-password-toggle mb-3">
                                <div class="d-flex justify-content-between">
                                    <label class="form-label" for="password"><?php echo e(get_label('password', 'Password')); ?> <span
                                            class="asterisk">*</span></label>
                                    <a href="<?php echo e(url('forgot-password')); ?>">
                                        <small><?php echo e(get_label('forgot_password', 'Forgot Password')); ?>?</small>
                                    </a>
                                </div>
                                <div class="input-group input-group-merge">
                                    <input type="password" id="password" class="form-control" name="password"
                                        placeholder="<?= get_label('please_enter_password', 'Please enter password') ?>"
                                        value="<?= config('constants.ALLOW_MODIFICATION') === 0 ? '123456' : '' ?>"
                                        aria-describedby="password" />
                                    <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                </div>
                            </div>

                        <?php
                            $settings = get_settings('general_settings');

                        ?>
                        <?php if(!empty($settings['recaptcha_enabled']) && $settings['recaptcha_enabled']): ?>
                            <div class="mb-4">
                                <label class="form-label d-block"><?php echo e(get_label('captcha', 'Captcha')); ?> <span
                                        class="asterisk">*</span></label>
                                <div class="d-flex justify-content-start">
                                    <?php echo NoCaptcha::display(); ?>

                                </div>
                                <?php if($errors->has('g-recaptcha-response')): ?>
                                    <span class="text-danger small d-block mt-1">
                                        <?php echo e($errors->first('g-recaptcha-response')); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                            <div class="mb-4">
                                <button class="btn btn-primary d-grid w-100" id="submit_btn"
                                    type="submit"><?php echo e(get_label('login', 'Login')); ?></button>
                            </div>
                            <?php if(!isset($general_settings['allowSignup']) || $general_settings['allowSignup'] == 1): ?>
                                <div class="text-center">
                                    <p class="mb-<?php echo e(config('constants.ALLOW_MODIFICATION') === 0 ? '3' : '0'); ?>">
                                        <?php echo e(get_label('dont_have_account', 'Don\'t have an account?')); ?> <a
                                            href="<?php echo e(url('signup')); ?>"><?php echo e(get_label('sign_up', 'Sign Up')); ?></a></p>
                                </div>
                            <?php endif; ?>
                            <?php if(config('constants.ALLOW_MODIFICATION') === 0): ?>
                                <div class="mb-3">
                                    <button class="btn btn-success d-grid w-100 admin-login" type="button">Login As
                                        Admin</button>
                                </div>
                                <div class="mb-3">
                                    <button class="btn btn-info d-grid w-100 member-login" type="button">Login As Team
                                        Member</button>
                                </div>
                                <div class="mb-3">
                                    <button class="btn btn-warning d-grid w-100 client-login" type="button">Login As
                                        Client</button>
                                </div>
                            <?php endif; ?>
                        </form>
                    </div>
                </div>
                <!-- /Register -->
            </div>
        </div>
    </div>
    <!-- / Content -->
    <?php echo NoCaptcha::renderJs(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/capoit/apps.capo.it.com/resources/views/auth/login.blade.php ENDPATH**/ ?>