
<?php $__env->startSection('title'); ?>
    <?= $is_favorite == 1 ? get_label('favorite_projects', 'Favorite projects') : get_label('projects', 'Projects') ?> -
    <?= get_label('grid_view', 'Grid view') ?>
<?php $__env->stopSection(); ?>
<?php
    $user = getAuthenticatedUser();
?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex justify-content-between mb-2 mt-4">
            <div>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-style1">
                        <li class="breadcrumb-item">
                            <a href="<?php echo e(url('home')); ?>"><?= get_label('home', 'Home') ?></a>
                        </li>
                        <li class="breadcrumb-item"><a
                                href="<?php echo e(url(getUserPreferences('projects', 'default_view'))); ?>"><?= get_label('projects', 'Projects') ?></a>
                        </li>
                        <?php if($is_favorite == 1): ?>
                            <li class="breadcrumb-item"><?= get_label('favorite', 'Favorite') ?></li>
                        <?php endif; ?>
                        <li class="breadcrumb-item active"><?= get_label('grid', 'Grid') ?></li>
                    </ol>
                </nav>
            </div>
            <div>
                <?php
                    $projectDefaultView = getUserPreferences('projects', 'default_view');
                ?>
                <?php if(!$projectDefaultView || $projectDefaultView === 'projects'): ?>
                    <span class="badge bg-primary"><?= get_label('default_view', 'Default View') ?></span>
                <?php else: ?>
                    <a href="javascript:void(0);"><span class="badge bg-secondary" id="set-default-view"
                            data-type="projects"
                            data-view="grid"><?= get_label('set_as_default_view', 'Set as Default View') ?></span></a>
                <?php endif; ?>
            </div>
            <div>
                <?php
                    // Base URLs for different views
                    $listUrl = $is_favorite == 1 ? url('projects/list/favorite') : url('projects/list');
                    $kanbanUrl =
                        $is_favorite == 1
                            ? route('projects.kanban_view', ['type' => 'favorite'])
                            : route('projects.kanban_view');
                    $ganttChartUrl =
                        $is_favorite == 1
                            ? route('projects.gantt_chart', ['type' => 'favorite'])
                            : route('projects.gantt_chart');

                    // Get the statuses and tags from the request, if they exist
                    $selectedStatuses = request()->has('statuses')
                        ? 'statuses[]=' . implode('&statuses[]=', request()->input('statuses'))
                        : '';
                    $selectedTags = request()->has('tags')
                        ? 'tags[]=' . implode('&tags[]=', request()->input('tags'))
                        : '';

                    // Build the query string by concatenating statuses and tags if they exist
                    $queryParams = '';
                    if ($selectedStatuses || $selectedTags) {
                        $queryParams = '?' . trim($selectedStatuses . '&' . $selectedTags, '&');
                    }

                    // Final URLs with filters
                    $finalListUrl = url($listUrl . $queryParams);
                    $finalKanbanUrl = $kanbanUrl . $queryParams;
                ?>
                <a href="javascript:void(0);" data-bs-toggle="offcanvas" data-bs-target="#create_project_offcanvas">
                    <button type="button" class="btn btn-sm btn-primary action_create_projects" data-bs-toggle="tooltip"
                        data-bs-placement="left"
                        data-bs-original-title="<?= get_label('create_project', 'Create project') ?>">
                        <i class='bx bx-plus'></i>
                    </button>
                </a>
                <a href="<?php echo e($finalListUrl); ?>">
                    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" data-bs-placement="left"
                        data-bs-original-title="<?= get_label('list_view', 'List view') ?>">
                        <i class='bx bx-list-ul'></i>
                    </button>
                </a>

                <a href="<?php echo e($finalKanbanUrl); ?>">
                    <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" data-bs-placement="left"
                        data-bs-original-title="<?= get_label('kanban_view', 'Kanban View') ?>">
                        <i class='bx bx-layout'></i>
                    </button>
                </a>

                <a href="<?php echo e($ganttChartUrl); ?>"><button type="button" class="btn btn-sm btn-primary"
                        data-bs-toggle="tooltip" data-bs-placement="left"
                        data-bs-original-title="<?= get_label('gantt_chart_view', 'Gantt Chart View') ?>"><i
                            class='bx bx-bar-chart'></i></button></a>
                <a href="<?php echo e(route('projects.calendar_view')); ?>"><button type="button" class="btn btn-sm btn-primary"
                        data-bs-toggle="tooltip" data-bs-placement="left"
                        data-bs-original-title="<?= get_label('calendar_view', 'Calendar view') ?>"><i
                            class='bx bx-calendar'></i></button></a>
            </div>
        </div>
        <div class="row">
            <div class="col-md-3 mb-3">
                <select class="form-select js-example-basic-multiple" id="sort" aria-label="Default select example"
                    data-placeholder="<?= get_label('select_sort_by', 'Select Sort By') ?>" data-allow-clear="true">
                    <option></option>
                    <option value="newest" <?= request()->sort && request()->sort == 'newest' ? 'selected' : '' ?>>
                        <?= get_label('newest', 'Newest') ?></option>
                    <option value="oldest" <?= request()->sort && request()->sort == 'oldest' ? 'selected' : '' ?>>
                        <?= get_label('oldest', 'Oldest') ?></option>
                    <option value="recently-updated"
                        <?= request()->sort && request()->sort == 'recently-updated' ? 'selected' : '' ?>>
                        <?= get_label('most_recently_updated', 'Most recently updated') ?></option>
                    <option value="earliest-updated"
                        <?= request()->sort && request()->sort == 'earliest-updated' ? 'selected' : '' ?>>
                        <?= get_label('least_recently_updated', 'Least recently updated') ?></option>
                </select>
            </div>
            <?php
                // Get selected statuses and tags from the request
                $selectedStatuses = request()->input('statuses', []);
                $selectedTags = request()->input('tags', []);

                $filterStatuses = \App\Models\Status::whereIn('id', $selectedStatuses)->get();
                $filterTags = \App\Models\Tag::whereIn('id', $selectedTags)->get();
            ?>
            <div class="col-md-4 mb-3">
                <select class="form-select statuses_filter" id="selected_statuses" name="statuses[]"
                    aria-label="Default select example"
                    data-placeholder="<?= get_label('filter_by_statuses', 'Filter by statuses') ?>" data-allow-clear="true"
                    multiple>
                    <?php $__currentLoopData = $filterStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($status->id); ?>" selected><?php echo e($status->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-4 mb-3">
                <select id="selected_tags" class="form-control tags_select" name="tag[]" multiple="multiple"
                    data-placeholder="<?= get_label('filter_by_tags', 'Filter by tags') ?>" data-allow-clear="true"
                    multiple>
                    <?php $__currentLoopData = $filterTags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($tag->id); ?>" selected><?php echo e($tag->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-1">
                <div>
                    <button type="button" id="filter" class="btn btn-sm btn-primary" data-bs-toggle="tooltip"
                        data-bs-placement="left" data-bs-original-title="<?= get_label('filter', 'Filter') ?>"><i
                            class='bx bx-filter-alt'></i></button>
                </div>
            </div>
        </div>
        <?php if(is_countable($projects) && count($projects) > 0): ?>
            <?php
                $showSettings =
                    $user->can('edit_projects') || $user->can('delete_projects') || $user->can('create_projects');
                $canEditProjects = $user->can('edit_projects');
                $canDeleteProjects = $user->can('delete_projects');
                $canDuplicateProjects = $user->can('create_projects');
                $webGuard = Auth::guard('web')->check();
            ?>
            <div class="d-flex row mt-4">
                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-6">
                        <div class="card mb-3">
                            <div class="card-body card-body-project-grid">
                                <?php if($project->tags->isNotEmpty()): ?>
                                    <div class="mb-3">
                                        <?php $__currentLoopData = $project->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge bg-<?php echo e($tag->color); ?> mt-1"><?php echo e($tag->title); ?></span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php endif; ?>
                                <div class="d-flex justify-content-between">
                                    <h4 class="card-title"><a
                                            href="<?php echo e(url('projects/information/' . $project->id)); ?>"><strong><?php echo e($project->title); ?></strong></a>
                                    </h4>
                                    <div class="d-flex align-items-center justify-content-center">
                                        <a href="javascript:void(0);" class="quick-view" data-id="<?php echo e($project->id); ?>"
                                            data-type="project">
                                            <i class='bx bx bx-info-circle text-info' data-bs-toggle="tooltip"
                                                data-bs-placement="right"
                                                data-bs-original-title="<?php echo e(get_label('quick_view', 'Quick View')); ?>"></i>
                                        </a>
                                        <a href="javascript:void(0);" class="mx-2">
                                            <i class='bx <?php echo e(getFavoriteStatus($project->id) ? 'bxs' : 'bx'); ?>-star favorite-icon text-warning'
                                                data-id="<?php echo e($project->id); ?>" data-bs-toggle="tooltip"
                                                data-bs-placement="right"
                                                data-bs-original-title="<?php echo e(getFavoriteStatus($project->id) ? get_label('remove_favorite', 'Click to remove from favorite') : get_label('add_favorite', 'Click to mark as favorite')); ?>"
                                                data-favorite="<?php echo e(getFavoriteStatus($project->id)); ?>"></i>
                                        </a>
                                        <a href="javascript:void(0);">
                                            <i class='bx <?php echo e(getPinnedStatus($project->id) ? 'bxs' : 'bx'); ?>-pin pinned-icon text-success'
                                                data-id="<?php echo e($project->id); ?>" data-bs-toggle="tooltip"
                                                data-bs-placement="right"
                                                data-bs-original-title="<?php echo e(getPinnedStatus($project->id) ? get_label('click_unpin', 'Click to Unpin') : get_label('click_pin', 'Click to Pin')); ?>"
                                                data-pinned="<?php echo e(getPinnedStatus($project->id)); ?>"></i>
                                        </a>
                                        <?php if($webGuard || $project->client_can_discuss): ?>
                                            <a href="<?php echo e(route('projects.info', ['id' => $project->id])); ?>#navs-top-discussions"
                                                class="ms-2">
                                                <i class='bx bx-message-rounded-dots text-danger' data-bs-toggle="tooltip"
                                                    data-bs-placement="right"
                                                    data-bs-original-title="<?php echo e(get_label('discussions', 'Discussions')); ?>"></i>
                                            </a>
                                        <?php endif; ?>
                                        <a href="<?php echo e(url('projects/mind-map/' . $project->id)); ?>"
                                            class="<?php if($showSettings): ?> mx-2 <?php else: ?> ms-2 <?php endif; ?>">
                                            <i class="bx bx-sitemap text-primary" data-bs-toggle="tooltip"
                                                data-bs-placement="right"
                                                data-bs-original-title="<?= get_label('mind_map', 'Mind Map') ?>"></i>
                                        </a>
                                        <?php if($showSettings): ?>
                                            <a href="javascript:void(0);" class="mr-2" data-bs-toggle="dropdown"
                                                aria-expanded="false">
                                                <i class='bx bx-cog' id="settings-icon"></i>
                                            </a>
                                            <ul class="dropdown-menu">
                                                <?php if($canEditProjects): ?>
                                                    <a href="javascript:void(0);" class="edit-project" data-offcanvas="true"
                                                        data-id="<?php echo e($project->id); ?>">
                                                        <li class="dropdown-item">
                                                            <i
                                                                class='menu-icon tf-icons bx bx-edit text-primary'></i><?= get_label('update', 'Update') ?>
                                                        </li>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if($canDeleteProjects): ?>
                                                    <a href="javascript:void(0);" class="delete" data-reload="true"
                                                        data-type="projects" data-id="<?php echo e($project->id); ?>">
                                                        <li class="dropdown-item">
                                                            <i
                                                                class='menu-icon tf-icons bx bx-trash text-danger'></i><?= get_label('delete', 'Delete') ?>
                                                        </li>
                                                    </a>
                                                <?php endif; ?>
                                                <?php if($canDuplicateProjects): ?>
                                                    <a href="javascript:void(0);" class="duplicate" data-type="projects"
                                                        data-id="<?php echo e($project->id); ?>" data-title="<?php echo e($project->title); ?>"
                                                        data-reload="true">
                                                        <li class="dropdown-item">
                                                            <i
                                                                class='menu-icon tf-icons bx bx-copy text-warning'></i><?= get_label('duplicate', 'Duplicate') ?>
                                                        </li>
                                                    </a>
                                                <?php endif; ?>
                                            </ul>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php if($project->budget != ''): ?>
                                    <span class='badge bg-label-primary me-1'>
                                        <?php echo e(format_currency($project->budget)); ?></span>
                                <?php endif; ?>
                                <div class="my-<?php echo e($project->budget != '' ? '3' : '2'); ?>">
                                    <div class="row align-items-center">
                                        <!-- Status Select Column -->
                                        <div class="col-md-<?php echo e($project->note ? '7' : '6'); ?>">
                                            <label for="statusSelect"
                                                class="form-label"><?= get_label('status', 'Status') ?></label>
                                            <div class="d-flex align-items-center">
                                                <select
                                                    class="form-select form-select-sm select-bg-label-<?php echo e($project->status->color); ?>"
                                                    id="statusSelect" data-id="<?php echo e($project->id); ?>"
                                                    data-original-status-id="<?php echo e($project->status->id); ?>"
                                                    data-original-color-class="select-bg-label-<?php echo e($project->status->color); ?>">
                                                    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $disabled = canSetStatus($status) ? '' : 'disabled';
                                                        ?>
                                                        <option value="<?php echo e($status->id); ?>"
                                                            class="badge bg-label-<?php echo e($status->color); ?>"
                                                            <?php echo e($project->status->id == $status->id ? 'selected' : ''); ?>

                                                            <?php echo e($disabled); ?>>
                                                            <?php echo e($status->title); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php if($project->note): ?>
                                                    <i class="bx bx-notepad text-primary ms-1" data-bs-toggle="tooltip"
                                                        data-bs-offset="0,4" data-bs-placement="top"
                                                        data-bs-original-title="<?php echo e($project->note); ?>"></i>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <!-- Priority Select Column -->
                                        <div class="col-md-<?php echo e($project->note ? '5' : '6'); ?>">
                                            <label for="prioritySelect"
                                                class="form-label"><?= get_label('priority', 'Priority') ?></label>
                                            <select
                                                class="form-select form-select-sm select-bg-label-<?php echo e($project->priority ? $project->priority->color : 'secondary'); ?>"
                                                id="prioritySelect" data-id="<?php echo e($project->id); ?>"
                                                data-original-priority-id="<?php echo e($project->priority ? $project->priority->id : ''); ?>"
                                                data-original-color-class="select-bg-label-<?php echo e($project->priority ? $project->priority->color : 'secondary'); ?>">
                                                <option value="" class="badge bg-label-secondary">-</option>
                                                <?php $__currentLoopData = $priorities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $priority): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($priority->id); ?>"
                                                        class="badge bg-label-<?php echo e($priority->color); ?>"
                                                        <?php echo e($project->priority && $project->priority->id == $priority->id ? 'selected' : ''); ?>>
                                                        <?php echo e($priority->title); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between my-4">
                                    <span><i class='bx bx-task text-primary'></i>
                                        <b><?= isAdminOrHasAllDataAccess() ? count($project->tasks) : $auth_user->project_tasks($project->id)->count() ?></b>
                                        <?= get_label('tasks', 'Tasks') ?></span>
                                    <a href="<?php echo e(url('projects/tasks/draggable/' . $project->id)); ?>"><button
                                            type="button"
                                            class="btn btn-sm rounded-pill btn-outline-primary"><?= get_label('tasks', 'Tasks') ?></button></a>
                                </div>
                                <div class="row mt-2">
                                    <div class="col-md-6">
                                        <p class="card-text">
                                            <?= get_label('users', 'Users') ?>:
                                        <ul class="list-unstyled users-list avatar-group d-flex align-items-center m-0">
                                            <?php
                                                                            $users = $project->users;
                                                                            $count = count($users);
                                                                            $displayed = 0;
                                                                            if ($count > 0) {
                                                                                // Case 1: Users are less than or equal to 10
                                                                                foreach ($users as $user) {
                                                                                    if ($displayed < 10) { ?>
                                            <li class="avatar avatar-sm pull-up"
                                                title="<?= $user->first_name ?> <?= $user->last_name ?>">
                                                <a href="<?php echo e(url('/users/profile/' . $user->id)); ?>">
                                                    <img src="<?= $user->photo ? asset('storage/' . $user->photo) : asset('storage/photos/no-image.jpg') ?>"
                                                        class="rounded-circle"
                                                        alt="<?= $user->first_name ?> <?= $user->last_name ?>">
                                                </a>
                                            </li>
                                            <?php
                                                                                        $displayed++;
                                                                                    } else {
                                                                                        // Case 2: Users are greater than 10
                                                                                        $remaining = $count - $displayed;
                                                                                        echo '<span class="badge badge-center rounded-pill bg-primary mx-1">+' . $remaining . '</span>';
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                // Add edit option at the end
                                                                                echo '<a href="javascript:void(0)" class="btn btn-icon btn-sm btn-outline-primary btn-sm rounded-circle edit-project update-users-clients" data-offcanvas="true" data-id="' . $project->id . '"><span class="bx bx-edit"></span></a>';
                                                                            } else {
                                                                                // Case 3: Not assigned
                                                                                echo '<span class="badge bg-primary">' . get_label('not_assigned', 'Not assigned') . '</span>';
                                                                                // Add edit option at the end
                                                                                echo '<a href="javascript:void(0)" class="btn btn-icon btn-sm btn-outline-primary btn-sm rounded-circle edit-project update-users-clients" data-id="' . $project->id . '"><span class="bx bx-edit"></span></a>';
                                                                            }
                                                                            ?>
                                        </ul>
                                        </p>
                                    </div>
                                    <div class="col-md-6">
                                        <p class="card-text">
                                            <?= get_label('clients', 'Clients') ?>:
                                        <ul class="list-unstyled users-list avatar-group d-flex align-items-center m-0">
                                            <?php
                                                                            $clients = $project->clients;
                                                                            $count = $clients->count();
                                                                            $displayed = 0;
                                                                            if ($count > 0) {
                                                                                foreach ($clients as $client) {
                                                                                    if ($displayed < 10) { ?>
                                            <li class="avatar avatar-sm pull-up"
                                                title="<?= $client->first_name ?> <?= $client->last_name ?>">
                                                <a href="<?php echo e(url('/clients/profile/' . $client->id)); ?>">
                                                    <img src="<?= $client->photo ? asset('storage/' . $client->photo) : asset('storage/photos/no-image.jpg') ?>"
                                                        class="rounded-circle"
                                                        alt="<?= $client->first_name ?> <?= $client->last_name ?>">
                                                </a>
                                            </li>
                                            <?php
                                                                                        $displayed++;
                                                                                    } else {
                                                                                        $remaining = $count - $displayed;
                                                                                        echo '<span class="badge badge-center rounded-pill bg-primary mx-1">+' . $remaining . '</span>';
                                                                                        break;
                                                                                    }
                                                                                }
                                                                                // Add edit option at the end
                                                                                echo '<a href="javascript:void(0)" class="btn btn-icon btn-sm btn-outline-primary btn-sm rounded-circle edit-project update-users-clients" data-offcanvas="true" data-id="' . $project->id . '"><span class="bx bx-edit"></span></a>';
                                                                            } else {
                                                                                // Display "Not assigned" badge
                                                                                echo '<span class="badge bg-primary">' . get_label('not_assigned', 'Not assigned') . '</span>';
                                                                                // Add edit option at the end
                                                                                echo '<a href="javascript:void(0)" class="btn btn-icon btn-sm btn-outline-primary btn-sm rounded-circle edit-project update-users-clients" data-offcanvas="true" data-id="' . $project->id . '"><span class="bx bx-edit"></span></a>';
                                                                            }
                                                                            ?>
                                        </ul>
                                        </p>
                                    </div>
                                </div>
                                <?php if($project->start_date || $project->end_date): ?>
                                    <div class="row mt-2">
                                        <div class="col-md-6 text-start">
                                            <?php if($project->start_date): ?>
                                                <i
                                                    class='bx bx-calendar text-success'></i><?= get_label('starts_at', 'Starts at') ?>
                                                : <?php echo e(format_date($project->start_date)); ?>

                                            <?php endif; ?>
                                        </div>

                                        <?php if($project->end_date): ?>
                                            <div class="col-md-6 text-end">
                                                <i
                                                    class='bx bx-calendar text-danger'></i><?= get_label('ends_at', 'Ends at') ?>
                                                : <?php echo e(format_date($project->end_date)); ?>

                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <div>
                    <?php echo e($projects->links()); ?>

                </div>
            </div>
            <!-- delete project modal -->
        <?php else: ?>
            <?php $type = 'projects'; ?>
            <?php if (isset($component)) { $__componentOriginal0fbbaf7987e44b855eae69b67dad7fdf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0fbbaf7987e44b855eae69b67dad7fdf = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.empty-state-card','data' => ['type' => $type]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('empty-state-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($type)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0fbbaf7987e44b855eae69b67dad7fdf)): ?>
<?php $attributes = $__attributesOriginal0fbbaf7987e44b855eae69b67dad7fdf; ?>
<?php unset($__attributesOriginal0fbbaf7987e44b855eae69b67dad7fdf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0fbbaf7987e44b855eae69b67dad7fdf)): ?>
<?php $component = $__componentOriginal0fbbaf7987e44b855eae69b67dad7fdf; ?>
<?php unset($__componentOriginal0fbbaf7987e44b855eae69b67dad7fdf); ?>
<?php endif; ?>
        <?php endif; ?>
    </div>
    <script>
        var add_favorite = '<?= get_label('add_favorite', 'Click to mark as favorite') ?>';
        var remove_favorite = '<?= get_label('remove_favorite', 'Click to remove from favorite') ?>';
    </script>
    <script src="<?php echo e(asset('assets/js/pages/project-grid.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/capoit/apps.capo.it.com/resources/views/projects/grid_view.blade.php ENDPATH**/ ?>