
<?php $__env->startSection('title'); ?>
<?= get_label('payslips', 'Payslips') ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between mb-2 mt-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb breadcrumb-style1">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(url('home')); ?>"><?= get_label('home', 'Home') ?></a>
                    </li>
                    <li class="breadcrumb-item active">
                        <?= get_label('payslips', 'Payslips') ?>
                    </li>
                </ol>
            </nav>
        </div>
        <div>
            <a href="<?php echo e(url('payslips/create')); ?>"><button type="button" class="btn btn-sm btn-primary action_create_payslips" data-bs-toggle="tooltip" data-bs-placement="left" data-bs-original-title=" <?= get_label('create_payslip', 'Create payslip') ?>"><i class="bx bx-plus"></i></button></a>
        </div>
    </div>
    <?php if($payslips > 0): ?>
    <?php
    $visibleColumns = getUserPreferences('payslips');
    ?>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-4 mb-3">
                    <input class="form-control" type="month" id="filter_payslip_month" name="month">
                </div>
                <?php if(isAdminOrHasAllDataAccess()): ?>
                <div class="col-md-4 mb-3">
                    <select class="form-select users_select" id="user_filter" aria-label="Default select example" data-placeholder="<?= get_label('select_users', 'Select Users') ?>" multiple>
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <select class="form-select users_select" id="user_creators_filter" aria-label="Default select example" data-placeholder="<?= get_label('select_user_creators', 'Select User Creators') ?>" multiple>                                                
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <select class="form-select clients_select" id="client_creators_filter" aria-label="Default select example" data-placeholder="<?= get_label('select_client_creators', 'Select Client Creators') ?>" multiple>                        
                    </select>
                </div>
                <?php endif; ?>
                <div class="col-md-4 mb-3">
                    <select class="form-select js-example-basic-multiple" id="status_filter" aria-label="Default select example" data-placeholder="<?= get_label('select_statuses', 'Select statuses') ?>" data-allow-clear="true" multiple>
                        <option value="1"><?= get_label('paid', 'Paid') ?></option>
                        <option value="0"><?= get_label('unpaid', 'Unpaid') ?></option>
                    </select>
                </div>
            </div>
            <div class="table-responsive text-nowrap">
                <input type="hidden" id="data_type" value="payslips">
                <input type="hidden" id="data_table" value="payslips_table">
                <input type="hidden" id="save_column_visibility">
                <input type="hidden" id="multi_select">
                <table id="payslips_table" data-toggle="table" data-loading-template="loadingTemplate" data-url="<?php echo e(url('/payslips/list')); ?>" data-icons-prefix="bx" data-icons="icons" data-show-refresh="true" data-total-field="total" data-trim-on-search="false" data-data-field="rows" data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true" data-side-pagination="server" data-show-columns="true" data-pagination="true" data-sort-name="id" data-sort-order="desc" data-mobile-responsive="true" data-query-params="queryParams">
                    <thead>
                        <tr>
                            <th data-checkbox="true"></th>
                            <th data-field="id" data-visible="<?php echo e((in_array('id', $visibleColumns) || empty($visibleColumns)) ? 'true' : 'false'); ?>" data-sortable="true" data-formatter="idFormatter"><?= get_label('id', 'ID') ?></th>
                            <th data-field="user" data-visible="<?php echo e((in_array('user', $visibleColumns) || empty($visibleColumns)) ? 'true' : 'false'); ?>" data-sortable="false"><?= get_label('user', 'User') ?></th>
                            <th data-field="month" data-visible="<?php echo e((in_array('month', $visibleColumns) || empty($visibleColumns)) ? 'true' : 'false'); ?>" data-sortable="true"><?= get_label('month', 'Month') ?></th>
                            <th data-field="basic_salary" data-visible="<?php echo e((in_array('basic_salary', $visibleColumns) || empty($visibleColumns)) ? 'true' : 'false'); ?>" data-sortable="true"><?= get_label('basic_salary', 'Basic salary') ?></th>
                            <th data-field="working_days" data-sortable="true" data-visible="<?php echo e((in_array('working_days', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('working_days', 'Working days') ?></th>
                            <th data-field="lop_days" data-sortable="true" data-visible="<?php echo e((in_array('lop_days', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('lop_days', 'Loss of pay days') ?></th>
                            <th data-field="paid_days" data-sortable="true" data-visible="<?php echo e((in_array('paid_days', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('paid_days', 'Paid days') ?></th>
                            <th data-field="leave_deduction" data-sortable="true" data-visible="<?php echo e((in_array('leave_deduction', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('leave_deduction', 'Leave deduction') ?></th>
                            <th data-field="ot_hours" data-sortable="true" data-visible="<?php echo e((in_array('ot_hours', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('over_time_hours', 'Over time hours') ?></th>
                            <th data-field="ot_rate" data-sortable="true" data-visible="<?php echo e((in_array('ot_rate', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('over_time_rate', 'Over time rate') ?></th>
                            <th data-field="ot_payment" data-sortable="true" data-visible="<?php echo e((in_array('ot_payment', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('over_time_payment', 'Over time payment') ?></th>
                            <th data-field="incentives" data-sortable="true" data-visible="<?php echo e((in_array('incentives', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('incentives', 'Incentives') ?></th>
                            <th data-field="bonus" data-sortable="true" data-visible="<?php echo e((in_array('bonus', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('bonus', 'Bonus') ?></th>
                            <th data-field="total_allowance" data-sortable="true" data-visible="<?php echo e((in_array('total_allowance', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('total_allowance', 'Total allowance') ?></th>
                            <th data-field="total_deductions" data-sortable="true" data-visible="<?php echo e((in_array('total_deductions', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('total_deductions', 'Total deductions') ?></th>
                            <th data-field="net_pay" data-visible="<?php echo e((in_array('net_pay', $visibleColumns) || empty($visibleColumns)) ? 'true' : 'false'); ?>" data-sortable="true"><?= get_label('net_pay', 'Net pay') ?></th>
                            <th data-field="payment_method" data-sortable="true" data-visible="<?php echo e((in_array('payment_method', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('payment_method', 'Payment method') ?></th>
                            <th data-field="payment_date" data-sortable="true" data-visible="<?php echo e((in_array('payment_date', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('payment_date', 'Payment date') ?></th>
                            <th data-field="status" data-visible="<?php echo e((in_array('status', $visibleColumns) || empty($visibleColumns)) ? 'true' : 'false'); ?>" data-sortable="true"><?= get_label('status', 'Status') ?></th>
                            <th data-field="note" data-sortable="true" data-visible="<?php echo e((in_array('note', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('note', 'Note') ?></th>
                            <th data-field="created_by" data-sortable="false" data-visible="<?php echo e((in_array('created_by', $visibleColumns)) ? 'true' : 'false'); ?>"><?php echo e(get_label('created_by', 'Created by')); ?></th>
                            <th data-field="created_at" data-sortable="true" data-visible="<?php echo e((in_array('created_at', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('created_at', 'Created at') ?></th>
                            <th data-field="updated_at" data-sortable="true" data-visible="<?php echo e((in_array('updated_at', $visibleColumns)) ? 'true' : 'false'); ?>"><?= get_label('updated_at', 'Updated at') ?></th>
                            <th data-field="actions" data-visible="<?php echo e((in_array('actions', $visibleColumns) || empty($visibleColumns)) ? 'true' : 'false'); ?>"><?php echo e(get_label('actions', 'Actions')); ?></th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
    <?php else: ?>
    <?php
    $type = 'Payslips'; ?>
    <?php if (isset($component)) { $__componentOriginal0fbbaf7987e44b855eae69b67dad7fdf = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0fbbaf7987e44b855eae69b67dad7fdf = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.empty-state-card','data' => ['type' => $type]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('empty-state-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($type)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0fbbaf7987e44b855eae69b67dad7fdf)): ?>
<?php $attributes = $__attributesOriginal0fbbaf7987e44b855eae69b67dad7fdf; ?>
<?php unset($__attributesOriginal0fbbaf7987e44b855eae69b67dad7fdf); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0fbbaf7987e44b855eae69b67dad7fdf)): ?>
<?php $component = $__componentOriginal0fbbaf7987e44b855eae69b67dad7fdf; ?>
<?php unset($__componentOriginal0fbbaf7987e44b855eae69b67dad7fdf); ?>
<?php endif; ?>
    <?php endif; ?>
</div>
<script>
    var label_update = '<?= get_label('update', 'Update') ?>';
    var label_delete = '<?= get_label('delete', 'Delete') ?>';
    var label_duplicate = '<?= get_label('duplicate', 'Duplicate') ?>';
    var label_payslip_id_prefix = '<?= get_label('payslip_id_prefix', 'PSL-') ?>';
    var decimal_points = <?= intval($general_settings['decimal_points_in_currency'] ?? '2') ?>;
</script>
<script src="<?php echo e(asset('assets/js/pages/payslips.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/capoit/apps.capo.it.com/resources/views/payslips/list.blade.php ENDPATH**/ ?>