<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'id',
    'title' => 'Offcanvas Title',
    'size' => 'offcanvas-responsive', // Example: 'offcanvas-w-600', 'offcanvas-lg'
    'icon' => 'bx bx-menu', // Default icon
    'submitLabel' => 'Save',
    'submitIcon' => 'bx bx-check',
    'closeLabel' => 'Close',
    'closeIcon' => 'bx bx-x',
    'formId' => null,
    'formMethod' => 'POST',
    'formAction' => '#',
    'showFooter' => true,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'id',
    'title' => 'Offcanvas Title',
    'size' => 'offcanvas-responsive', // Example: 'offcanvas-w-600', 'offcanvas-lg'
    'icon' => 'bx bx-menu', // Default icon
    'submitLabel' => 'Save',
    'submitIcon' => 'bx bx-check',
    'closeLabel' => 'Close',
    'closeIcon' => 'bx bx-x',
    'formId' => null,
    'formMethod' => 'POST',
    'formAction' => '#',
    'showFooter' => true,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>


<div class="offcanvas offcanvas-end <?php echo e($size); ?>" tabindex="-1" id="<?php echo e($id); ?>"
    aria-labelledby="<?php echo e($id); ?>Label">
    <div class="offcanvas-header bg-dark">
        <h5 class="offcanvas-title text-white" id="<?php echo e($id); ?>Label">
            <?php if($icon): ?>
                <i class="<?php echo e($icon); ?> me-2"></i>
            <?php endif; ?> <?php echo e($title); ?>

        </h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>

    <div class="offcanvas-body">
        <form class="new-form-submit-event" id="<?php echo e($formId); ?>" action="<?php echo e($formAction); ?>"
            method="<?php echo e(strtolower($formMethod) === 'get' ? 'GET' : 'POST'); ?>"
            <?php if(strtolower($formMethod) !== 'get'): ?> enctype="multipart/form-data" <?php endif; ?>>
            <?php echo csrf_field(); ?>
            <?php if(!in_array(strtolower($formMethod), ['get', 'post'])): ?>
                <?php echo method_field($formMethod); ?>
            <?php endif; ?>

            <?php echo e($slot); ?>


            <?php if($showFooter): ?>
                <div class="d-flex justify-content-end mt-4 gap-2">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="offcanvas">
                        <i class="<?php echo e($closeIcon); ?> me-1"></i><?php echo e($closeLabel); ?>

                    </button>
                    <button type="submit" id="submit_btn" class="btn btn-primary">
                        <i class="<?php echo e($submitIcon); ?> me-1"></i><?php echo e($submitLabel); ?>

                    </button>
                </div>
            <?php endif; ?>
        </form>
    </div>
</div>
<?php /**PATH /home/capoit/apps.capo.it.com/resources/views/components/ui/offcanvas.blade.php ENDPATH**/ ?>