<!DOCTYPE html>
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default"
    data-assets-path="<?php echo e(asset('assets/')); ?>" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title><?php echo $__env->yieldContent('title'); ?> - <?php echo e($general_settings['company_title'] ?? 'Taskify'); ?></title>
    <meta name="description" content="" />
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon"
        href="<?php echo e(asset($general_settings['favicon'] ?? 'storage/logos/default_favicon.png')); ?>" />
    <!-- Fonts -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/google-fonts.css')); ?>" />
    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/boxicons.css')); ?>" />
    <!-- Core CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/core.css')); ?>" class="template-customizer-core-css" />

    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/theme-default.css')); ?>"
        class="template-customizer-theme-css" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/demo.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom.css')); ?>" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/css/pages/page-auth.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/apex-charts.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/lightbox/lightbox.min.css')); ?>" />
    <!-- Page CSS -->
    <!-- Helpers -->
    <script src="<?php echo e(asset('assets/vendor/js/helpers.js')); ?>"></script>
    <!-- Date picker -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/daterangepicker.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap-datetimepicker.min.css')); ?>" />
    <link href="<?php echo e(asset('assets/css/select2.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/bootstrap-table.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/dragula.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/toastr.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/dropzone.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/fullcalendar/core/main.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/fullcalendar/daygrid/main.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/fullcalendar/list/main.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/css/js-draw.css')); ?>" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@24.3.4/build/css/intlTelInput.css">

    <script src="https://cdn.jsdelivr.net/npm/intl-tel-input@24.3.4/build/js/intlTelInput.min.js"></script>


    <?php if(Request::is('projects/kanban') || Request::is('leads/kanban-view')): ?>
        <link
            href="https://fonts.googleapis.com/css2?family=Lato:wght@400;700&family=Open+Sans:wght@400;700&family=Montserrat:wght@400;600;700&family=Source+Sans+Pro:wght@400;600;700&family=Nunito:wght@400;700&family=Raleway:wght@400;600;700&family=Ubuntu:wght@400;700&family=Work+Sans:wght@400;700&display=swap"
            rel="stylesheet">
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/project-kanban.css')); ?>" />
    <?php endif; ?>
    <?php if(Request::is('projects/mind-map/*')): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/mind-map.css')); ?>" />
    <?php endif; ?>
    <?php if(Request::is('projects/gantt-chart') || Request::is('projects/gantt-chart/favorite')): ?>
        <link rel="stylesheet" href="<?php echo e(asset('assets/css/frappe-gantt.css')); ?>" />
    <?php endif; ?>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="<?php echo e(asset('assets/js/config.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/vendor/libs/jquery/jquery.js')); ?>"></script>
    <!-- Charts -->
    <script src="<?php echo e(asset('assets/js/apexcharts.js')); ?>"></script>
    <script>
        var baseUrl = "<?php echo e(url('/')); ?>";
        var currencySymbol = "<?php echo e($general_settings['currency_symbol'] ?? ''); ?>";
    </script>

    <!-- PWA Manifest -->
    <?php $config = (new \LaravelPWA\Services\ManifestService)->generate(); echo $__env->make( 'laravelpwa::meta' , ['config' => $config])->render(); ?>
</head>

<body>

    <!-- Layout wrapper -->
    <?php if(
    Request::is('forgot-password') ||
    Request::is('/') ||
    Request::segment(1) == 'reset-password' ||
    Request::is('install') ||
    //  Request::is('system-health') ||
    Request::is('signup') ||
    Request::is('privacy-policy')
): ?>
        <?php echo $__env->yieldContent('content'); ?>
        <?php echo $__env->make('labels', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php else: ?>
        <div class="layout-wrapper layout-content-navbar">
            <div class="layout-container">
                <!-- Menu -->
                <?php if (auth('web')->check() || auth('client')->check() || auth()->guard('sanctum')->check()): ?>
                <?php if (isset($component)) { $__componentOriginal5893a4ae82cbde8a6e1ba16203c33ac0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5893a4ae82cbde8a6e1ba16203c33ac0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.menu','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('menu'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5893a4ae82cbde8a6e1ba16203c33ac0)): ?>
<?php $attributes = $__attributesOriginal5893a4ae82cbde8a6e1ba16203c33ac0; ?>
<?php unset($__attributesOriginal5893a4ae82cbde8a6e1ba16203c33ac0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5893a4ae82cbde8a6e1ba16203c33ac0)): ?>
<?php $component = $__componentOriginal5893a4ae82cbde8a6e1ba16203c33ac0; ?>
<?php unset($__componentOriginal5893a4ae82cbde8a6e1ba16203c33ac0); ?>
<?php endif; ?>
                <!-- Layout container -->
                <div class="layout-page">
                    <?php echo $__env->make('partials._navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <!-- Content wrapper -->
                    <div class="content-wrapper">
                        <?php echo $__env->make('labels', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        <?php echo $__env->yieldContent('content'); ?>
                        <?php if(!isset($unauthorized)): ?>
                            <?php echo $__env->make('modals', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            <?php echo $__env->make('offcanvas', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        <?php endif; ?>
                    </div>
                    <!-- Content wrapper -->
                    <!-- footer -->
                    <?php if (isset($component)) { $__componentOriginal8a8716efb3c62a45938aca52e78e0322 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8a8716efb3c62a45938aca52e78e0322 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.footer','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('footer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8a8716efb3c62a45938aca52e78e0322)): ?>
<?php $attributes = $__attributesOriginal8a8716efb3c62a45938aca52e78e0322; ?>
<?php unset($__attributesOriginal8a8716efb3c62a45938aca52e78e0322); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8a8716efb3c62a45938aca52e78e0322)): ?>
<?php $component = $__componentOriginal8a8716efb3c62a45938aca52e78e0322; ?>
<?php unset($__componentOriginal8a8716efb3c62a45938aca52e78e0322); ?>
<?php endif; ?>
                    <!-- / footer -->
                <?php else: ?>
                    <div class="container-fluid container-p-y">
                        <div class="misc-wrapper d-flex flex-column align-items-center justif-content-center">
                            <h2 class="mx-2 mb-2"><?= get_label('session_expired', 'Session expired') ?>!!!</h2>
                            <div class="my-5">
                                <img src="../assets/img/illustrations/page-misc-error-light.png"
                                    alt="page-misc-error-light" width="500" class="img-fluid"
                                    data-app-dark-img="illustrations/page-misc-error-dark.png"
                                    data-app-light-img="illustrations/page-misc-error-light.png" />
                            </div>
                            <a href="<?php echo e(url('')); ?>"
                                class="btn btn-primary"><?= get_label('log_in', 'Log in') ?></a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <!-- / Layout page -->
        </div>
        <!-- Overlay -->
        <div class="layout-overlay layout-menu-toggle"></div>
    </div>
    <script>
        var manage_notifications = '<?= getAuthenticatedUser()->can('manage_system_notifications') ? 'true' : 'false' ?>';
    </script>
<?php endif; ?>
<!-- / Layout wrapper -->
<?php if(Auth::guard('web')->check()): ?>
    <div onclick="toggleChatIframe()">
        <span>
            <a href="javascript:void(0);">
                <img src="<?php echo e(asset('storage/chat-icon.png')); ?>" class="chat-img" alt="Chat">
            </a>
        </span>
    </div>
    <div id="chatIframeContainer" class="chat-iframe-container">
        <iframe src="<?php echo e(url('chat')); ?>" frameborder="0" class="chat-iframe"></iframe>
    </div>
<?php endif; ?>
<script src="<?php echo e(asset('assets/js/time-tracker.js')); ?>"></script>
<?php if(getAuthenticatedUser() && getAuthenticatedUser()->can('create_timesheet')): ?>
    <!-- Timer image -->
    <div onclick="open_timer_section()">
        <span>
            <a href="javascript:void(0);" data-bs-toggle="tooltip" data-bs-placement="left"
                data-bs-original-title="<?= get_label('time_tracker', 'Time tracker') ?>">
                <img src="<?php echo e(asset('storage/94150-clock.png')); ?>" class="timer-img" id="timer-image"
                    alt="Timer" data-bs-toggle="modal" data-bs-target="#timerModal">
            </a>
        </span>
    </div>
<?php endif; ?>


<?php if(config('constants.ALLOW_MODIFICATION') == '0'): ?>
<!-- Floating Buy Now Button -->
   <?php echo $__env->make('components.taskify-ecosystem-drawer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php endif; ?>


<!-- Core JS -->
<!-- build:js assets/vendor/js/core.js -->
<script src="<?php echo e(asset('assets/vendor/libs/popper/popper.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/js/bootstrap.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>"></script>
<script src="<?php echo e(asset('assets/vendor/js/menu.js')); ?>"></script>
<!-- endbuild -->
<!-- Main JS -->
<script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/ui-toasts.js')); ?>"></script>
<!-- Place this tag in your head or just before your close body tag. -->
<script async defer src="<?php echo e(asset('assets/js/buttons.js')); ?>"></script>
<!-- select 2 js !-->
<script src="<?php echo e(asset('assets/js/select2.min.js')); ?>"></script>
<script>
    $(document).ready(function() {
        // Initialize Select2 on elements with the class 'js-example-basic-multiple'
        $('.js-example-basic-multiple').each(function() {
            var $this = $(this);
            var $parentModal = $this.closest('.modal');

            // Determine the allowClear setting
            var allowClear = $this.data('allow-clear') === "true";

            var isMultiple = $this.prop('multiple');

            var select2Options = {
                allowClear: allowClear,
                closeOnSelect: !isMultiple,
                language: {
                    noResults: function() {
                        return label_no_results_found;
                    },
                    searching: function() {
                        return label_searching;
                    }
                }
            };

            if ($parentModal.length) {
                // If inside a modal, set dropdownParent to the closest modal
                select2Options.dropdownParent = $parentModal;
            }

            // Initialize Select2 with the options
            $this.select2(select2Options);
            $('.cancel-button').on('click', function() {
                $this.select2('close'); // Close the dropdown
            });

        });
    });
</script>
<!-- Bootstrap-table -->
<script src="<?php echo e(asset('assets/js/bootstrap-table/bootstrap-table.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/bootstrap-table/bootstrap-table-export.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/bootstrap-table/tableExport.min.js')); ?>"></script>
<!-- Dragula -->
<script src="<?php echo e(asset('assets/js/dragula.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/popper.js')); ?>"></script>
<!-- Toastr -->
<script src="<?php echo e(asset('assets/js/toastr.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/ui-toasts.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/ui-popover.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/tinymce.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/tinymce-jquery.min.js')); ?>"></script>
<!-- Date picker -->
<script src="<?php echo e(asset('assets/js/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/daterangepicker.js')); ?>"></script>
<script src="<?php echo e(asset('assets/lightbox/lightbox.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/dropzone.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/extended-ui-perfect-scrollbar.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/fullcalendar/core/main.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/fullcalendar/interaction/main.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/fullcalendar/daygrid/main.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/fullcalendar/list/main.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/fullcalendar/google-calendar/main.js')); ?>"></script>

<!-- Js Draw -->
<script src="<?php echo e(asset('assets/js/js-draw.js')); ?>"></script>

<?php if(Request::is('projects/mind-map/*')): ?>
    <script src="<?php echo e(asset('assets/js/mind-map.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/dom-to-image.js')); ?>"></script>

    <!-- screenshot plugin -->
    <script src="<?php echo e(asset('assets/js/mindmap-screenshot.js')); ?>"></script>
<?php endif; ?>
<?php if(Request::is('preferences')): ?>
    <script src="<?php echo e(asset('assets/js/Sortable.min.js')); ?>"></script>
<?php endif; ?>

<?php if(Request::is('projects/gantt-chart') || Request::is('projects/gantt-chart/favorite')): ?>
    <script src="<?php echo e(asset('assets/js/frappe-gantt.js')); ?>"></script>
<?php endif; ?>
<script src="<?php echo e(asset('assets/js/tribute.js')); ?>"></script>
<script src="https://www.gstatic.com/firebasejs/8.10.0/firebase-app.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.10.0/firebase-messaging.js"></script>

<script>
    // const firebaseConfig = {
    //     apiKey: "AIzaSyACyBtmMz5PO_yQ_V3GTCRB9mlrP99ctN8",
    //     authDomain: "taskify-210db.firebaseapp.com",
    //     databaseURL: "https://taskify-210db-default-rtdb.firebaseio.com",
    //     projectId: "taskify-210db",
    //     storageBucket: "taskify-210db.appspot.com",
    //     messagingSenderId: "208242375433",
    //     appId: "1:208242375433:web:cfaaeb51e3417c03e131d8",
    //     measurementId: "G-TN9S72E85S"
    // };

    // // Initialize Firebase
    // firebase.initializeApp(firebaseConfig);
    // const messaging = firebase.messaging();

    // messaging.getToken().then((currentToken) => {
    //     if (currentToken) {
    //         console.log('FCM Token:', currentToken);
    //     } else {
    //         console.log('No registration token available. Request permission to generate one.');
    //     }
    // }).catch((err) => {
    //     console.log('An error occurred while retrieving token. ', err);
    // });
</script>

<?php if (auth('web')->check() || auth('client')->check() || auth()->guard('sanctum')->check()): ?>
<script>
    var authUserId = '<?= getAuthenticatedUser()->id ?>';
    var isAdminOrHasAllDataAccess = '<?= isAdminOrHasAllDataAccess() ?>';
    var canManageUsers = '<?= checkPermission('manage_users') ?>';
    var canManageClients = '<?= checkPermission('manage_clients') ?>';
    var guard = '<?= getGuardName() ?>';
</script>
<?php endif; ?>
<?php
    $user = getAuthenticatedUser();
    $permissions = $user ? $user->getPermissionsViaRoles() : collect();
?>
<script>
    var permissions = <?php echo json_encode($permissions->pluck('name'), 15, 512) ?>;
</script>
<!-- Custom js -->
<script>
    var csrf_token = '<?php echo e(csrf_token()); ?>';
    var js_date_format = '<?php echo e($js_date_format ?? 'YYYY-MM-DD'); ?>';
</script>
<?php if (\Illuminate\Support\Facades\Blade::check('role', 'admin')): ?>
<script>
    var isAdmin = 1;
</script>
<?php endif; ?>
<?php
    $allowedMaxUploadSize = isset($general_settings['allowed_max_upload_size'])
        ? $general_settings['allowed_max_upload_size']
        : 512;
    $maxFilesAllowed = isset($general_settings['max_files_allowed']) ? $general_settings['max_files_allowed'] : 10;
    $allowedFileTypes = isset($general_settings['allowed_file_types'])
        ? $general_settings['allowed_file_types']
        : '.png,.jpg,.pdf,.doc,.docx,.xls,.xlsx,.zip,.rar,.txt';
    $allowedFileTypes = str_replace(' ', '', $allowedFileTypes);
?>
<script>
    var toastTimeOut = <?= isset($general_settings['toast_time_out']) ? $general_settings['toast_time_out'] : 5 ?>;
    var toastPosition =
        <?= isset($general_settings['toast_position']) ? "'" . $general_settings['toast_position'] . "'" : "'toast-top-right'" ?>;
    var allowedMaxFilesize = <?= $allowedMaxUploadSize ?>;
    var allowedMaxFilesizeFormatted = '<?= formatSize(1024 * 1024 * $allowedMaxUploadSize) ?>';
    var maxFilesAllowed = <?= $maxFilesAllowed ?>;
    var allowedFileTypes = '<?= $allowedFileTypes ?>';
</script>

<script src="<?php echo e(asset('assets/js/custom.js')); ?>"></script>
<?php if(session()->has('message')): ?>
<script>
    toastr.options = {
        "positionClass": toastPosition,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": parseFloat(toastTimeOut) * 1000,
        "progressBar": true,
        "extendedTimeOut": "1000",
        "closeButton": true
    };
    toastr.success('<?php echo e(session('message')); ?>', 'Success');
</script>
<?php elseif(session()->has('error')): ?>
<script>
    toastr.options = {
        "positionClass": toastPosition,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": parseFloat(toastTimeOut) * 1000,
        "progressBar": true,
        "extendedTimeOut": "1000",
        "closeButton": true
    };
    toastr.error('<?php echo e(session('error')); ?>', 'Error');
</script>
<?php elseif(session()->has('info')): ?>
<script>
    toastr.options = {
        "positionClass": toastPosition,
        "showDuration": "300",
        "hideDuration": "1000",
        "timeOut": parseFloat(toastTimeOut) * 1000,
        "progressBar": true,
        "extendedTimeOut": "1000",
        "closeButton": true
    };
    toastr.info('<?php echo e(session('info')); ?>', 'Info');
</script>
<?php endif; ?>

</body>

</html>
<?php /**PATH /home/capoit/apps.capo.it.com/resources/views/layout.blade.php ENDPATH**/ ?>